﻿using System;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web
{
    /// <summary>
    /// JavaScriptのライブラリ
    /// </summary>
    public class JavaScript
    {
        private static string CLASS_NAME = "Framework.Web.JavaScript";

        /// <summary>
        /// 確認ダイアログを表示するためのスクリプトを登録する
        /// </summary>
        /// <param name="wc"></param>
        /// <param name="msg"></param>
        public static void RegisterConfirm(WebControl wc, string msg)
        {
            string script = "if (!confirm('{0}')) return false;".Fmt(msg);

            if (wc is Button)
            {
                var btn = wc as Button;
                btn.OnClientClick = "{0}{1}".Fmt(btn.OnClientClick, script);
            }
            else if (wc is LinkButton)
            {
                var btn = wc as LinkButton;
                btn.OnClientClick = "{0}{1}".Fmt(btn.OnClientClick, script);
            }
            else
            {
                wc.Attributes["onclick"] = "{0}{1}".Fmt(wc.Attributes["onclick"], script);
            }
        }

        /// <summary>
        /// 2度押し防止スクリプトを登録する
        /// </summary>
        /// <param name="wc"></param>
        public static void RegisterStop2ndPost(WebControl wc)
        {
            var page = wc.Page;
            if (page.ClientScript.IsClientScriptBlockRegistered(page.GetType(), "Stop2ndPost") == false)
            {
                var pscript = @"
                    |function Stop2ndPost() {{
                    |   if (document.readyState != null &&
                    |       document.readyState != 'complete') {{
                    |
                    |       alert('{0}');
                    |       return false;
                    |    }}
                    |    return true;
                    |}}"
                    .StripMargin()
                    .Fmt(LTextMgr.GetText(CLASS_NAME + ".Stop2ndPost"));

                page.ClientScript.RegisterClientScriptBlock(page.GetType(), "Stop2ndPost", pscript, true);
            }

            var cscript = "if (!Stop2ndPost()) return false;";

            if (wc is Button)
            {
                var btn = wc as Button;
                btn.OnClientClick = "{0}{1}".Fmt(btn.OnClientClick, cscript);
            }
            else if (wc is LinkButton)
            {
                var btn = wc as LinkButton;
                btn.OnClientClick = "{0}{1}".Fmt(btn.OnClientClick, cscript);
            }
            else
            {
                wc.Attributes["onclick"] = "{0}{1}".Fmt(wc.Attributes["onclick"], cscript);
            }
        }

        /// <summary>
        /// 標準設定で別Windowを開く。標準設定の内容はWindowStyleクラスのデフォルト値を参照のこと。
        /// </summary>
        /// <param name="c"></param>
        /// <param name="url"></param>
        /// <param name="name"></param>
        public static void RegisterWindowOpen(System.Web.UI.Control c, string url, string name)
        {
            JavaScript.RegisterWindowOpen(c, url, name, new WindowStyle());
        }

        /// <summary>
        /// WindowStyleを指定して別Windowを開く。
        /// </summary>
        /// <param name="c"></param>
        /// <param name="url"></param>
        /// <param name="name"></param>
        /// <param name="style"></param>
        public static void RegisterWindowOpen(System.Web.UI.Control c, string url, string name, WindowStyle style)
        {
            if (style.NoCache)
            {
                //キャッシュしたページを表示させないように、ユニークなURLにする。
                url += (url.IndexOf('?') < 0) ? "?" : "&";
                url += string.Format("nocache={0}", DateTime.Now.Ticks);
            }

            string script = string.Format(@"
                |var style = '{0}';
                |if ({1} > 0 && {2} > 0){{
                |    style = style + ',left=' + '{1}' + ',top=' + '{2}';                         
                |}}
                |else if ({3} > 0 && {4} > 0){{
                |    var x = (screen.width - {3}) / 2; 
                |    var y = (screen.height - {4}) / 2;
                |    style = style + ',left=' + x + ',top=' + y; 
                |}}
                |var win = window.open('{5}', '{6}', style); 
                |if (win) win.focus();
                ".StripMargin()
                , style.GetStyle(), style.Left, style.Top, style.Width, style.Height, url, name);
            
            if (c is Page)
            {
                var page = (Page)c;

                //ブラウザの「戻る」ボタンなどでページを再表示したときに、再度ポップアップさせないための対応。（クッキーの値で判定）
                var cname = "windowopend_" + name;
                if (page.Request.Cookies[cname] != null)
                {
                    page.Response.Cookies[cname].Path = page.Request.Path.SubstrBeforeLast("/") + "/";
                    page.Response.Cookies[cname].Expires = DateTime.Now.AddDays(-1);
                }

                script = string.Format(@"
                    |var cstr = document.cookie;
                    |if (cstr.indexOf('{0}', 0) < 0) {{
                    |    {1}
                    |}}
                    |document.cookie = '{0}=1';
                    ".StripMargin(), cname, script);

                ((Page)c).ClientScript.RegisterStartupScript(c.GetType(), "WindowOpen", script, true);
            }
            else if (c is WebControl)
            {
                ((WebControl)c).Attributes["onclick"] = script + "return false;";
            }
        }

        /// <summary>
        /// 画面を閉じるスクリプトを登録する
        /// </summary>
        /// <param name="c"></param>
        public static void RegisterWindowClose(System.Web.UI.Control c)
        {
            string script = "window.close();";

            if (c is Page)
            {
                ((Page)c).ClientScript.RegisterStartupScript(c.GetType(), "WindowClose", script, true);
            }
            else if (c is WebControl)
            {
                ((WebControl)c).Attributes["onclick"] = script;
            }
        }

        /// <summary>
        /// javasceiptで使えるように文字列をエスケープする
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string Escape(string str)
        {
            return str.Replace("\\", "\\\\").Replace("'", "\\'");
        }
    }
}
